# 🧹 DAFTAR FILE UNTUK DIBERSIHKAN

## ❌ FILE YANG PERLU DIHAPUS:

### **File Test & Development:**
1. `test.php` - File test umum
2. `test_email.php` - Test konfigurasi email (tidak dipakai lagi)
3. `test_lupa_password.php` - Test fitur lupa password
4. `check_database.php` - Cek database (hanya untuk development)

### **File Darurat (Tidak Diperlukan Lagi):**
5. `reset_admin_darurat.php` - Reset password admin darurat
6. `reset_kasir_darurat.php` - Reset password kasir darurat
7. `kasir_reset_password.php` - Reset password kasir (tidak dipakai)

### **File Dokumentasi Lama/Duplikat:**
8. `CARA_SETUP_EMAIL.md` - Panduan setup email (tidak relevan)
9. `INSTRUKSI_FINAL.md` - Instruksi lama
10. `MULAI_DISINI.txt` - Instruksi lama
11. `PANDUAN_DARURAT.md` - Panduan darurat lama
12. `PANDUAN_FINAL_LENGKAP.md` - Panduan duplikat
13. `PANDUAN_RESET_PASSWORD.md` - Panduan duplikat
14. `PANDUAN_TEST.md` - Panduan test lama
15. `README_LUPA_PASSWORD.md` - Dokumentasi lama

### **File SQL Lama:**
16. `RESET_PASSWORD_ADMIN_DARURAT.sql` - SQL darurat
17. `setup_email_database.sql` - Setup email (tidak relevan)
18. `sim_toko2 (2).sql` - Backup SQL duplikat
19. `sim_toko2.zip` - Backup zip lama

---

## ✅ FILE YANG TETAP DIPERTAHANKAN:

### **File Utama (PENTING!):**
1. `koneksi.php` - Koneksi database ✅
2. `login.php` - Halaman login ✅
3. `logout.php` - Logout ✅
4. `heartbeat.php` - Heartbeat kasir ✅

### **Fitur Lupa Password (PENTING!):**
5. `lupa_password.php` - Fitur lupa password admin ✅
6. `reset_password.php` - Halaman reset password ✅

### **Dokumentasi Final:**
7. `README_LUPA_PASSWORD_FINAL.md` - Panduan lengkap final ✅

### **Folder:**
8. `admin/` - Folder admin ✅
9. `kasir/` - Folder kasir ✅

---

## 🗑️ PERINTAH UNTUK MENGHAPUS FILE:

Jalankan perintah ini di PowerShell (dari folder sim_toko2):

```powershell
# Hapus file test
Remove-Item test.php
Remove-Item test_email.php
Remove-Item test_lupa_password.php
Remove-Item check_database.php

# Hapus file darurat
Remove-Item reset_admin_darurat.php
Remove-Item reset_kasir_darurat.php
Remove-Item kasir_reset_password.php

# Hapus dokumentasi lama
Remove-Item CARA_SETUP_EMAIL.md
Remove-Item INSTRUKSI_FINAL.md
Remove-Item MULAI_DISINI.txt
Remove-Item PANDUAN_DARURAT.md
Remove-Item PANDUAN_FINAL_LENGKAP.md
Remove-Item PANDUAN_RESET_PASSWORD.md
Remove-Item PANDUAN_TEST.md
Remove-Item README_LUPA_PASSWORD.md

# Hapus file SQL lama
Remove-Item RESET_PASSWORD_ADMIN_DARURAT.sql
Remove-Item setup_email_database.sql
Remove-Item "sim_toko2 (2).sql"
Remove-Item sim_toko2.zip
```

---

## 📊 RINGKASAN:

**Total file yang akan dihapus:** 19 file  
**Total file yang dipertahankan:** 7 file + 2 folder

---

## ✅ STRUKTUR FOLDER SETELAH DIBERSIHKAN:

```
sim_toko2/
├── admin/                          ← Folder admin
├── kasir/                          ← Folder kasir
├── koneksi.php                     ← Koneksi database
├── login.php                       ← Halaman login
├── logout.php                      ← Logout
├── heartbeat.php                   ← Heartbeat kasir
├── lupa_password.php               ← Fitur lupa password (admin)
├── reset_password.php              ← Reset password via link
└── README_LUPA_PASSWORD_FINAL.md   ← Panduan lengkap
```

**Bersih, rapi, dan hanya file yang diperlukan!** ✨

---

## ⚠️ CATATAN PENTING:

Sebelum menghapus, pastikan:
1. ✅ Fitur lupa password sudah berfungsi
2. ✅ Email admin sudah diupdate di database
3. ✅ Sudah test reset password
4. ✅ Backup database jika perlu

---

**Apakah Anda ingin saya jalankan perintah hapus file sekarang?**
