<?php
session_start();
include "../koneksi.php";

// Keamanan: Pastikan hanya admin yang bisa akses
if(!isset($_SESSION['id_user']) || $_SESSION['role'] != 'admin'){
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

// Gunakan query dengan UNIX_TIMESTAMP untuk akurasi realtime
$users = mysqli_query($koneksi, "SELECT id_user, last_activity, UNIX_TIMESTAMP(last_activity) as last_unix, UNIX_TIMESTAMP(NOW()) as server_unix FROM users");
$data = [];

while($u = mysqli_fetch_assoc($users)){
    $is_online = false;
    $last_unix = intval($u['last_unix']);
    $server_unix = intval($u['server_unix']);
    $diff = $server_unix - $last_unix;
    
    // Threshold 90 detik (heartbeat 60s + toleransi)
    if($last_unix > 0 && $diff < 90){
        $is_online = true;
    }
    
    $data[] = [
        'id_user'     => $u['id_user'],
        'is_online'   => $is_online,
        'last_seen'   => $u['last_activity'] ? date('H:i:s', $last_unix) : "-",
        'last_unix'   => $last_unix,
        'server_unix' => $server_unix
    ];
}

header('Content-Type: application/json');
echo json_encode($data);



