<?php
session_start();
include "../koneksi.php";

// Cek login admin
if(!isset($_SESSION['id_user']) || $_SESSION['role'] != 'admin'){
    header("Location: ../login.php");
    exit;
}

// Ambil ID user
$id = intval($_GET['id'] ?? 0);
if($id <= 0){
    header("Location: users.php");
    exit;
}

// Ambil data user dari database
$q = mysqli_query($koneksi, "SELECT * FROM users WHERE id_user=$id");
$user = mysqli_fetch_assoc($q);
if(!$user){
    echo "User tidak ditemukan!";
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Profil User - Admin</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
<style>
/* GLOBAL */
body {
    font-family: 'Poppins', sans-serif;
    background: #f4f7f6;
    margin: 0;
    padding: 0;
    color: #495057;
}
a{text-decoration:none;}

/* HEADER */
.header{
    background:linear-gradient(135deg,#0d6efd,#084298);
    color:#fff;
    padding:25px 20px;
    text-align:center;
    font-size:24px;
    font-weight:600;
    letter-spacing:1px;
    box-shadow:0 4px 12px rgba(0,0,0,0.1);
    position: relative;
    z-index: 10;
}

/* SIDEBAR */
.sidebar {
    width: 240px;
    background: #1e1e2f;
    color: #fff;
    position: fixed;
    top: 0;
    left: 0;
    height: 100vh;
    padding-top: 90px;
    transition: width 0.3s;
}
.sidebar h3 {
    text-align: center;
    margin-bottom: 25px;
    font-weight: 500;
    color: #cfd2ff;
    font-size: 18px;
}
.sidebar a {
    display: block;
    padding: 15px 25px;
    color: #ddd;
    font-weight: 500;
    transition: 0.3s;
    border-left: 4px solid transparent;
}
.sidebar a:hover {
    background: #343aeb;
    color: #fff;
    padding-left: 30px;
    border-left: 4px solid #fff;
}

/* CONTENT */
.content {
    margin-left:240px;
    padding:40px 50px;
    display: flex;
    justify-content: center;
}

/* PROFILE CARD */
.profile-card {
    background: #fff;
    border-radius: 20px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
    overflow: hidden;
    width: 100%;
    max-width: 480px;
    text-align: center;
    position: relative;
}

.card-header {
    background: linear-gradient(135deg, #0d6efd 0%, #0043a8 100%);
    padding: 40px 20px;
    color: white;
}

.profile-avatar {
    width: 100px;
    height: 100px;
    background: #fff;
    border-radius: 50%;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    font-size: 40px;
    color: #0d6efd;
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
    margin-bottom: 15px;
}

.card-header h2 {
    margin: 0;
    font-size: 24px;
    font-weight: 600;
}

.card-header .role-badge {
    display: inline-block;
    background: rgba(255,255,255,0.2);
    padding: 5px 15px;
    border-radius: 20px;
    font-size: 14px;
    margin-top: 10px;
    backdrop-filter: blur(5px);
}

.card-body {
    padding: 30px;
    text-align: left;
}

.info-item {
    margin-bottom: 20px;
    border-bottom: 1px solid #f0f0f0;
    padding-bottom: 15px;
}

.info-item:last-child {
    border-bottom: none;
    margin-bottom: 0;
}

.info-label {
    font-size: 12px;
    color: #888;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 5px;
    font-weight: 600;
}

.info-value {
    font-size: 16px;
    color: #333;
    font-weight: 500;
    display: flex;
    align-items: center;
}

.info-value i {
    color: #0d6efd;
    width: 25px;
    margin-right: 10px;
}

.btn-edit {
    display: block;
    width: 100%;
    background: #0d6efd;
    color: #fff;
    padding: 14px;
    border-radius: 12px;
    font-weight: 600;
    text-align: center;
    transition: 0.3s;
    border: none;
    box-shadow: 0 5px 15px rgba(13, 110, 253, 0.3);
    margin-top: 20px;
}

.btn-edit:hover {
    background: #0b5ed7;
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(13, 110, 253, 0.4);
}

.back-link {
    display: block;
    text-align: center;
    margin-top: 25px;
    color: #6c757d;
    font-weight: 500;
    font-size: 14px;
}

.back-link:hover {
    color: #0d6efd;
}

</style>
</head>
<body>

<div class="header">Profil User • Elino Computer</div>

<div class="sidebar">
    <h3>Menu Admin</h3>
    <a href="index.php">Dashboard</a>
    <a href="users.php">Kelola User</a>
    <a href="produk.php">Kelola Produk</a>
    <a href="transaksi.php">Transaksi</a>
    <a href="laporan.php">Laporan</a>
    <a href="../logout.php">Logout</a>
</div>

<div class="content">
    <div class="profile-card">
        <div class="card-header">
            <div class="profile-avatar">
                <i class="fas fa-user"></i>
            </div>
            <h2><?= htmlspecialchars($user['nama']); ?></h2>
            <div class="role-badge"><?= ucfirst(htmlspecialchars($user['role'])); ?></div>
        </div>
        
        <div class="card-body">
            <div class="info-item">
                <div class="info-label">Nama Lengkap</div>
                <div class="info-value">
                    <i class="fas fa-user"></i>
                    <?= htmlspecialchars($user['nama']); ?>
                </div>
            </div>

            <div class="info-item">
                <div class="info-label">Username Login</div>
                <div class="info-value">
                    <i class="fas fa-at"></i>
                    <?= htmlspecialchars($user['username']); ?>
                </div>
            </div>

            <div class="info-item">
                <div class="info-label">Email Perusahaan</div>
                <div class="info-value">
                    <i class="fas fa-envelope"></i>
                    <?= htmlspecialchars($user['email'] ?? 'Belum diatur'); ?>
                </div>
            </div>

            <div class="info-item">
                <div class="info-label">Role / Jabatan</div>
                <div class="info-value">
                    <i class="fas fa-id-badge"></i>
                    <?= ucfirst(htmlspecialchars($user['role'])); ?>
                </div>
            </div>

            <div class="info-item">
                <div class="info-label">Terakhir Aktif</div>
                <div class="info-value">
                    <i class="far fa-clock"></i>
                    <?php 
                    if($user['last_activity']){
                        echo date('d F Y, H:i', strtotime($user['last_activity'])) . ' WIB';
                    } else {
                        echo "Belum pernah aktif";
                    }
                    ?>
                </div>
            </div>

            <a href="edit_user.php?id=<?= $user['id_user']; ?>" class="btn-edit">
                <i class="fas fa-edit"></i> Edit Profil
            </a>

            <a href="users.php" class="back-link">
                <i class="fas fa-arrow-left"></i> Kembali ke Daftar User
            </a>
        </div>
    </div>
</div>

</body>
</html>
