<?php
session_start();
include "../koneksi.php";

if(!isset($_SESSION['id_user']) || $_SESSION['role'] != 'kasir'){
    header("Location: ../login.php");
    exit;
}

$kasir = $_SESSION['username'];
$produk_q = mysqli_query($koneksi,"SELECT * FROM produk ORDER BY id_produk ASC");
if(!$produk_q) die("Query produk gagal: ".mysqli_error($koneksi));
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Transaksi Penjualan - Elino.Computer</title>
<!-- Icon library -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
body,html{margin:0;padding:0;font-family:'Segoe UI',sans-serif;background:#e2e8f0;}
.header{background:#0f172a;color:#fff;padding:25px 30px;text-align:center;font-size:22px;box-shadow:0 4px 12px rgba(0,0,0,0.2);}
.header span{color:#38bdf8;font-weight:bold;}
.sidebar{width:220px;background:#1e293b;color:#fff;position:fixed;top:0; left:0;height:100%;padding-top:90px;}
.sidebar h3{text-align:center;margin-bottom:20px;font-size:18px;color:#f3f4f6;}
.sidebar a{display:flex;align-items:center;color:#e5e7eb;padding:12px 20px;text-decoration:none;transition:0.3s;}
.sidebar a:hover{background:#2563eb;color:#fff;border-radius:8px;}
.sidebar a i{margin-right:10px;}
.content{margin-left:220px;padding:30px;}
.container{max-width:900px;margin:auto;background:#fff;padding:25px;border-radius:12px;box-shadow:0 6px 16px rgba(0,0,0,0.15);}
h2{text-align:center;color:#0f172a;}
.form-group{margin-bottom:15px;max-width:300px;}
label{display:block;margin-bottom:5px;font-weight:600;}
input[type="date"], input[type="number"], input[type="text"]{width:100%;padding:8px;border-radius:6px;border:1px solid #ccc;}
table{width:100%;border-collapse:collapse;margin-top:20px;background:#fff;border-radius:12px;overflow:hidden;box-shadow:0 4px 12px rgba(0,0,0,0.1);}
th,td{padding:12px;text-align:center;border-bottom:1px solid #ddd;}
th{background:#0f172a;color:white;}
tr:hover{background:#f1f5f9;}
td input[type="number"]{width:80px;}
.totals{margin-top:20px;font-size:16px;font-weight:600;}
.button-group{margin-top:20px;text-align:center;}
.btn-submit{background:#22c55e;color:white;border:none;padding:12px 20px;border-radius:8px;cursor:pointer;}
.btn-submit:hover{background:#16a34a;}
.btn-back{background:#dc2626;color:white;padding:12px 20px;border-radius:8px;cursor:pointer;margin-left:10px;text-decoration:none;}
.btn-back:hover{background:#b91c1c;}

/* CUSTOM MODAL POPUP */
#customModal {
    display: none;
    position: fixed;
    inset: 0;
    background: rgba(15, 23, 42, 0.7);
    backdrop-filter: blur(4px);
    justify-content: center;
    align-items: center;
    z-index: 9999;
}
.modal-box {
    background: #fff;
    padding: 30px;
    border-radius: 16px;
    width: 90%;
    max-width: 400px;
    text-align: center;
    box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    animation: modalPop 0.3s cubic-bezier(0.34, 1.56, 0.64, 1);
}
@keyframes modalPop {
    from { transform: scale(0.8); opacity: 0; }
    to { transform: scale(1); opacity: 1; }
}
.modal-box i {
    font-size: 50px;
    color: #ef4444;
    margin-bottom: 15px;
}
.modal-box h3 {
    margin: 0 0 10px;
    color: #1e293b;
}
.modal-box p {
    color: #64748b;
    margin-bottom: 25px;
}
.btn-close-modal {
    background: #0f172a;
    color: #fff;
    border: none;
    padding: 10px 25px;
    border-radius: 8px;
    font-weight: 600;
    cursor: pointer;
    transition: 0.2s;
}
.btn-close-modal:hover { background: #334155; }
/* PAGINATION */
.pagination {
    display: flex;
    justify-content: center;
    margin-top: 20px;
    gap: 5px;
}
.pagination button {
    background: #fff;
    border: 1px solid #ddd;
    padding: 8px 14px;
    cursor: pointer;
    border-radius: 6px;
    transition: 0.3s;
    color: #333;
    font-weight: 500;
}
.pagination button.active {
    background: #0d6efd;
    color: white;
    border-color: #0d6efd;
}
.pagination button:hover:not(.active) {
    background: #f1f5f9;
}
.pagination button:disabled {
    cursor: not-allowed;
    opacity: 0.6;
}
</style>
</head>
<body>

<div class="header">🖥️ <span>Elino.Computer</span> - Transaksi Kasir</div>

<div class="sidebar">
<h3>Menu Kasir</h3>
<a href="dashboard_kasir.php"><i class="fa fa-tachometer-alt"></i> Dashboard</a>
<a href="transaksi.php"><i class="fa fa-cart-plus"></i> Transaksi Baru</a>
<a href="lihat_produk.php"><i class="fa fa-box"></i> Lihat Produk</a>
<a href="../logout.php"><i class="fa fa-right-from-bracket"></i> Logout</a>
</div>

<div class="content">
<div class="container">

<h2>🧾 Transaksi Penjualan</h2>

<form method="POST" action="preview_transaksi.php">

<div class="form-group">
<label>Tanggal</label>
<input type="date" name="tanggal" value="<?= date('Y-m-d') ?>" required>
</div>

<div style="display: flex; gap: 15px;">
    <div class="form-group" style="flex: 1;">
        <label>Kasir</label>
        <input type="text" name="kasir" value="<?= htmlspecialchars($kasir) ?>" readonly>
    </div>

    <div class="form-group" style="flex: 1;">
        <label>Cari Produk</label>
        <input type="text" id="cariProduk" placeholder="Ketik nama produk..." onkeyup="handleSearch()">
    </div>
</div>

<table id="tabelProduk">
<thead>
<tr>
<th>Produk</th>
<th>Stok</th>
<th>Harga</th>
<th>Jumlah</th>
</tr>
</thead>
<tbody id="tbodyProduk">
<?php while($p=mysqli_fetch_assoc($produk_q)) { ?>
<tr class="item-produk">
<td class="nama-produk"><?= htmlspecialchars($p['nama_produk']) ?></td>
<td><?= $p['stok'] ?></td>
<td>Rp <?= number_format($p['harga'],0,',','.') ?></td>
<td>
<input type="number"
name="qty[<?= $p['id_produk'] ?>]"
min="0"
max="<?= $p['stok'] ?>"
value="0"
class="qty-input"
data-harga="<?= $p['harga'] ?>">
</td>
</tr>
<?php } ?>
</tbody>
</table>

<!-- Pagination Controls -->
<div class="pagination" id="paginationControls"></div>

<div class="totals">
Total Belanja: Rp <span id="totalBelanja">0</span>
</div>

<div class="form-group">
<label>Uang Bayar</label>
<input type="text" name="bayar" id="uangBayar" required autocomplete="off" placeholder="Rp 0">
</div>

<div class="totals">
Kembalian: Rp <span id="kembalian">0</span>
</div>

<div class="button-group">
<button type="submit" class="btn-submit">💾 Proses Transaksi</button>
<a href="dashboard_kasir.php" class="btn-back">← Kembali</a>
</div>

</form>
</div>
</div>

<!-- Custom Pop Up Modal -->
<div id="customModal">
    <div class="modal-box">
        <i class="fa-solid fa-circle-xmark"></i>
        <h3 id="modalTitle">Kesalahan!</h3>
        <p id="modalMessage">Uang tidak cukup.</p>
        <button type="button" class="btn-close-modal" onclick="closeModal()">Tutup</button>
    </div>
</div>

<script>
// Logic Pagination & Search
const rowsPerPage = 6;
let currentPage = 1;
const allRows = Array.from(document.querySelectorAll('.item-produk'));
let filteredRows = [...allRows];

function renderTable() {
    // Hide all first
    allRows.forEach(row => row.style.display = 'none');

    // Calculate pagination
    const totalPages = Math.ceil(filteredRows.length / rowsPerPage);
    if(currentPage > totalPages) currentPage = 1;
    if(currentPage < 1) currentPage = 1;

    // Show current page items
    const start = (currentPage - 1) * rowsPerPage;
    const end = start + rowsPerPage;
    const pageItems = filteredRows.slice(start, end);
    
    pageItems.forEach(row => row.style.display = '');

    renderPagination(totalPages);
}

function renderPagination(totalPages) {
    const container = document.getElementById('paginationControls');
    container.innerHTML = '';

    if(totalPages <= 1) return;

    // Prev Button
    const btnPrev = document.createElement('button');
    btnPrev.innerText = 'Prev';
    btnPrev.type = 'button';
    btnPrev.onclick = () => { if(currentPage > 1) { currentPage--; renderTable(); } };
    if(currentPage === 1) btnPrev.disabled = true;
    container.appendChild(btnPrev);

    // Page Numbers
    // Simple logic: show all or max 5? Let's show all for simplicity as per admin page
    for(let i=1; i<=totalPages; i++) {
        const btn = document.createElement('button');
        btn.innerText = i;
        btn.type = 'button';
        if(i === currentPage) btn.classList.add('active');
        btn.onclick = () => { currentPage = i; renderTable(); };
        container.appendChild(btn);
    }

    // Next Button
    const btnNext = document.createElement('button');
    btnNext.innerText = 'Next';
    btnNext.type = 'button';
    btnNext.onclick = () => { if(currentPage < totalPages) { currentPage++; renderTable(); } };
    if(currentPage === totalPages) btnNext.disabled = true;
    container.appendChild(btnNext);
}

function handleSearch() {
    const input = document.getElementById('cariProduk');
    const filter = input.value.toUpperCase();

    filteredRows = allRows.filter(row => {
        const td = row.querySelector('.nama-produk');
        if(td) {
            const txtValue = td.textContent || td.innerText;
            return txtValue.toUpperCase().indexOf(filter) > -1;
        }
        return false;
    });

    currentPage = 1; // Reset to page 1 on search
    renderTable();
}

// Initial Render
renderTable();

const qtyInputs=document.querySelectorAll('.qty-input');
const totalEl=document.getElementById('totalBelanja');
const bayarEl=document.getElementById('uangBayar');
const kembaliEl=document.getElementById('kembalian');

function rupiah(n){return n.toLocaleString('id-ID');}

// Hitung total & kembalian
function hitung(){
    let total=0;
    qtyInputs.forEach(i=>{
        total+=(parseInt(i.value)||0)*parseInt(i.dataset.harga);
    });
    totalEl.textContent=rupiah(total);
    const bayar=parseInt(bayarEl.value.replace(/\D/g,''))||0;
    kembaliEl.textContent=rupiah(Math.max(0,bayar-total));
}

// Format input uang bayar otomatis pakai Rp dan titik
function formatInputRupiah(input){
    let angka = input.value.replace(/\D/g,'');
    if(angka === '') angka = '0';
    input.value = 'Rp ' + angka.replace(/\B(?=(\d{3})+(?!\d))/g,".");
}

// Event listener
qtyInputs.forEach(i=>i.addEventListener('input',hitung));
bayarEl.addEventListener('input', function(){
    formatInputRupiah(bayarEl);
    hitung();
});

// Modal
function showModal(title, msg) {
    document.getElementById('modalTitle').textContent = title;
    document.getElementById('modalMessage').textContent = msg;
    document.getElementById('customModal').style.display = 'flex';
}
function closeModal() {
    document.getElementById('customModal').style.display = 'none';
}

// Validasi saat submit
document.querySelector('form').addEventListener('submit', function(e) {
    let total = 0;
    qtyInputs.forEach(i => {
        total += (parseInt(i.value) || 0) * parseInt(i.dataset.harga);
    });
    
    const bayar = parseInt(bayarEl.value.replace(/\D/g,'')) || 0;

    if(total <= 0) {
        showModal("Keranjang Kosong", "Harap pilih minimal satu produk untuk transaksi.");
        e.preventDefault();
        return;
    }

    if(bayar < total) {
        showModal("Uang Tidak Cukup", "Nominal pembayaran kurang dari total belanja.");
        e.preventDefault();
    }
});
</script>

</body>
</html>
